package com.zzsn.event.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zs
 * @Description 事件分析栏目(支持版本逻辑) 枚举
 * @since 2021/12/9
 */
public enum AnalysisColumnEnum {


    CORE_SUMMARY(1, "核心摘要", "string", 1),

    EVENT_CONTEXT(2, "事件脉络", "array", 0),

    KEYWORD_TREND(3, "关键词趋势分析", "array", 0),

    CO_OCCURRENCE(4, "关键词共现", "array", 0),

    IMPACT_ASSESSMENT(5, "影响评估", "array", 1),

    MEASURE_SUGGEST(6, "应对建议", "array", 1),

    KNOWLEDGE_ENTRY(7, "知识词条", "array", 1),

    ENTERPRISE_CASE(8, "企业案例", "array", 1),

    COUNTRY_POLICY(9, "各国政策", "array", 1),

    DOMESTIC_SIMILAR_EVENT(10, "中国类似事件", "array", 1),

    FOREIGN_SIMILAR_EVENT(11, "各国类似事件", "array", 1),

    DRIVING_FACTORS(12, "事件核心驱动因素", "string", 1),

    RELATED_INDICATOR(13, "事件相关指标", "string", 1)
    ;

    //栏目编码
    private final Integer code;
    //栏目名称
    private final String name;
    //返回数据类型
    private final String resType;
    //是否需要大模型(1-是;0-否)
    private final Integer ynNeedLlm;

    AnalysisColumnEnum(int code, String name, String resType, Integer ynNeedLlm) {
        this.code = code;
        this.name = name;
        this.resType = resType;
        this.ynNeedLlm = ynNeedLlm;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getResType() {
        return resType;
    }

    public Integer getYnNeedLlm() {
        return ynNeedLlm;
    }

    public static List<AnalysisColumnEnum> llmList() {
        List<AnalysisColumnEnum> list = new ArrayList<>();
        for (AnalysisColumnEnum value : AnalysisColumnEnum.values()) {
            if (value.ynNeedLlm == 1) {
                list.add(value);
            }
        }
        return list;
    }

    public static AnalysisColumnEnum getByCode(Integer code) {
        for (AnalysisColumnEnum value : AnalysisColumnEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }
}
