package com.zzsn.event.llm;

import com.zzsn.event.config.properties.LlmProperties;

/**
 * 模型调用
 */
public interface LlmService {

    /**
     * glm模型调用
     *
     * @param modelType 模型类型
     * @param modelName 模型名称
     * @param system    提示词
     * @param content   引用内容
     * @return 大模型响应结果
     */
    String model(String modelType, String modelName, String system, String content);

    /**
     * 千问模型调用
     *
     * @param modelConfig 模型配置信息
     * @param system      提示词
     * @param content     引用内容
     * @return 大模型响应结果
     */
    String qwenModel(LlmProperties.ModelConfig modelConfig, String system, String content);
}
