package com.zzsn.event.enums;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson2.annotation.JSONCreator;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 采集器类型
 *
 * @author 张宗涵
 * @date 2024/4/29
 */
@Getter
@AllArgsConstructor
public enum EnumSourceType {
    UNKNOWN("0", "未知"),
    STATIC("1", "静态爬虫"),
    DYNAMIC("2", "动态爬虫"),
    BAIDU_METASEARCH("3", "百度元搜索"),
    GOOGLE_METASEARCH("4", "谷歌元搜索"),
    SOGOU_SEARCH("5", "搜狗搜索"),
    QIHOO_SEARCH("6", "360搜索"),
    SOGOU_WEIXIN_SEARCH("7", "搜狗微信搜索"),
    YAHOO_COLLECTION("8", "雅虎搜索采集"),
    TWITTER_COLLECTION("9", "推特搜素采集"),
    SINA_COLLECTION("10", "新浪接口采集"),
    WEIXIN_COLLECTION("11", "微信采集"),
    LATVIA_COLLECTION("12", "拉脱维亚接口采集"),
    OLD_COLLECTION("13", "旧采集库"),
    DIVINE("14", "神采"),
    WEIBO_COLLECTION("15", "微博采集"),
    CUSTOMIZED_COLLECTION("16", "定制采集"),
    CREDIT_CHINA("17", "信用中国"),
    GOVERNMENT_PURCHASE("18", "政府采购网"),
    CHINA_JUDGMENT_DOCUMENT("19", "中国裁判文书网"),
    TAX_PENALTY("20", "税务处罚网"),
    TODAY_HEADLINES("21", "今日头条"),
    TENCENT_NEWS("22", "腾讯新闻"),
    SOHU_NEWS("23", "搜狐新闻"),
    DOUYIN("24", "抖音"),
    TIEBA("25", "贴吧"),
    KUAISHOU("26", "快手"),
    BILIBILI("31", "哔哩哔哩"),
    GDELT("32", "GDELT数据采集"),
    TENDER_BID("33", "招投标"),
    ;

    private final String code;
    private final String description;

    // fastjson反序列化配置
    // 消费日志时反序列化用code，查es时反序列化用name
    @JSONCreator
    public static EnumSourceType getByCode(String value) {
        // 约定生产者发送日志时传code，字符串形式的数字
        if (NumberUtil.isNumber(value)) {
            for (EnumSourceType type : EnumSourceType.values()) {
                if (type.code.equals(value)) {
                    return type;
                }
            }
            // 存es时默认按照name存，所以查es时尝试使用name反序列化
        } else {
            for (EnumSourceType type : EnumSourceType.values()) {
                if (type.name().equals(value)) {
                    return type;
                }
            }
        }

        return EnumSourceType.UNKNOWN;
    }
}
