package com.zzsn.event.vo;


import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class InfoSourceVo {
    /**主键*/
    private String id;
    /****************************基本信息********************************/
    /**信息源编码*/
    private String infoSourceCode;
    /**信息源名称,微信公众号名称，微博名称*/
    private String webSiteName;
    /**栏目名称*/
    private String siteName;
    /**栏目URL，微信公众号URL,微博URL*/
    private String siteUri;
    /**微博认证方式(1:个人微博 2:官方微博)*/
    private String authMode;
    /**功能介绍，微博认证描述*/
    private String remarks;
    /**公众号BIZ*/
    private String biz;
    /**是否大V*/
    private int ynBigV;
    /**权威性*/
    private String authority;
    /**信息源类别ids*/
    private String infoSourceTypeId;
    private String infoSourceTypeName;
    /**信息源性质ids*/
    private List<String> infoSourceNatureIds;
    private String natureIds;
    private String infoSourceNatureNames;
    /**信息源组名称*/
    private String infoSourceGroupNames;
    /**网站重要级别*/
    private String siteLevel;
    /**国家*/
    private String country;
    /**地区*/
    private String area;
    /**语种*/
    private String language;
    /**是否(境外、公共、翻墙)*/
    private  String checkedList;
    /**历史数据URL*/
    private String hisUriExp;
    /**历史数据开始时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date hisDateStartTime;
    /**历史数据结束时间*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date hisDateEndTime;
    /**是否历史所有数据*/
    private String ynHisDataAll;
    /**状态*/
    private String status;

    /****************************列表页********************************/
    /**列表页URL*/
    private String listUrl;
    /**表达式类型*/
    private String listExpressionType;
    /**匹配资讯的url*/
    private String informationUrl;
    /**匹配资讯标题*/
    private String informationTitle;
    /**匹配资讯发布时间*/
    private String informationPublishDate;
    /**匹配资讯来源*/
    private String informationSource;
    /**列表信息块位置*/
    private String infoBlockPosition;
    /**抽取链接定位*/
    private String linkLocation;
    /**自定义实体*/
    private Object extractInfo;
    /**爬取深度*/
    private Integer crawlDepth;
    /**页码url*/
    private String pageUrl;
    /**匹配页码*/
    private String matchPage;
    /**开始页码*/
    private int pageStart;
    /**结束页码*/
    private int pageEnd;
    /**是否所有页*/
    private String ynPageAll;

    /**预警标签*/
    private List<Map<String,Object>> warningTag;

    /****************************详情页********************************/
    /**详情页表URL*/
    private int detailUrl;
    /**表达式类型*/
    private String detailExpressionType;
    /**匹配详情页标题*/
    private String detailExpressionTitle;
    private Integer titleExtractionMethodType;
    private String titleExtractionMethod;

    /**匹配详情页时间*/
    private String detailExpressionPublishDate;
    private Integer publishDateExtractionMethodType;
    private String publishDateExtractionMethod;

    /**匹配详情页来源*/
    private String detailExpressionSource;
    private Integer sourceExtractionMethodType;
    private String sourceExtractionMethod;

    /**匹配详情页作者*/
    private String detailExpressionAuthor;
    private Integer authorExtractionMethodType;
    private String authorExtractionMethod;

    /**匹配详情页摘要*/
    private String detailExpressionSummary;
    private Integer summaryExtractionMethodType;
    private String summaryExtractionMethod;

    /**匹配详情页正文*/
    private String detailExpressionContent;
    private Integer contentExtractionMethodType;
    private String contentExtractionMethod;

    /**自定义实体*/
    private Object detailInfo;
    /**是否下载附件*/
    private String ynDownload;

    /****************************数据页********************************/
    /**数据表格页URL*/
    private String formUrl;
    /**数据表格标题*/
    private String formTitle;
    /**表达式类型*/
    private String formType;
    /**数据表格表达式*/
    private String dataFormExpression;
    /**自定义*/
    private Object dataFormInfo;
    /**页码URL*/
    private String dataPageUrl;
    /**页码规则*/
    private String dataPageRule;
    /**开始页码*/
    private int dataPageStart;
    /**结束页码*/
    private int dataPageEnd;
    /**是否所有页码*/
    private String ynDataPageAll;

    /****************************存储设置********************************/
    /**数据类型*/
    private int dataType;
    /**数据格式*/
    private int dataFormat;
    /**数据存储方式*/
    private int dataStorageMode;
    /**数据存储信息*/
    private Object dataStorageInfo;

    /****************************爬取设置********************************/
    /**是否动态爬取*/
    private int ynDynamicCrawl;
    /**是否需要登陆*/
    private int ynLogin;
    /**登陆域名*/
    private String domainName;
    /**登陆链接*/
    private String link;
    /**登陆账号*/
    private String account;
    /**登陆密码*/
    private String passWord;
    /**userAgent*/
    private String userAgent;
    /**Referer*/
    private String referer;
    /**cookies*/
    private String cookies;
    /**headers*/
    private String headers;
    /**其它参数*/
    private String otherInfo;

    /****************************爬虫设置********************************/
    /**爬虫类别*/
    private int crawlType;
    /**爬虫名称*/
    private String crawlName;
    /**爬虫地址*/
    private String crawlAddress;
    /**参数*/
    private Object parameter;

    /****************************调度设置********************************/
    /**设置方式(1:自由设置 2:cron表达式)*/
    private Integer setMode;
    /**定时方式(1:时间间隔 2:立即执行)*/
    private String timerMode;
    /**定时单位(1分；2小时；3日；4月)*/
    private String unit;
    /**定时数值*/
    private Integer space;
    /**cron表达式*/
    private String cron;
    /**说明*/
    private String explaination;
    /**是否下载*/
    private Boolean downLoad;
    /**是否立即执行*/
    private Boolean execute;
    /**验证结果*/
    private String verification;

    /**所属单位*/
    private String company;
    /**所属行业*/
    private String industry;
    /**可信度*/
    private String reliability;
    /**原创度*/
    private String originality;
    /**父网站*/
    private String parentSite;
    /**是否保存快照（1：保存   0：不保存）*/
    private String ynSnapshot;
    private String sourceId;

    /**创建人*/
    private String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**更新人*/
    private String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**总采集量*/
    private Long totalCount;
    /**昨日采集量*/
    private Long yesterdayCount;
    /**近一周采集量*/
    private Long weekCount;
    /**近一月采集量*/
    private Long monthCount;
}
