package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.SubjectTypeMap;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题与类别关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-01
 * @Version: V1.0
 */
@Mapper
public interface SubjectTypeMapMapper extends BaseMapper<SubjectTypeMap> {

    void deleteBySubjectId (@Param("subjectId") String subjectId);

    /**
     * 分类下的专题id集合
     *
     * @param typeIds 分类id集合
     * @param userId
     * @author lkg
     * @date 2024/5/6
     */
    List<String> selectSubjectByTypeIds(@Param("typeIds") List<String> typeIds, @Param("userId")String userId);

    /**
     * 分类下的事件id集合
     *
     * @param typeIds 分类id集合
     * @param userId
     * @author lkg
     * @date 2024/5/6
     */
    List<String> selectEventByTypeIds(@Param("typeIds") List<String> typeIds, @Param("userId")String userId);
}
