package com.zzsn.event.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * dify大模型接口调用
 *
 * @author lkg
 * @date 2025/3/21
 */
@Slf4j
public class LLMUtil {


    final static String ChatGlm4_URL = "https://open.bigmodel.cn/api/paas/v4/chat/completions";
    final static String API_KEY = "2eb40c7bb8e4d22b389cd9ada5a8d6cc.bAbE6g6y71TeC0on";

    /**
     * LLM-推荐关键词
     *
     * @param keyword 关键词
     * @author lkg
     * @date 2025/3/21
     */
    public static List<String> wordRecommend(String keyword) {
        List<String> list = new ArrayList<>();
        JSONObject params = new JSONObject();
        List<JSONObject> messages = new ArrayList<>();
        JSONObject message = new JSONObject();
        String query = String.format("请推荐[%s]相关的10个近义词且只要结果", keyword);
        message.put("content", query);
        message.put("role", "user");
        messages.add(message);
        params.put("messages", messages);
        params.put("model", "glm-4-flash");
        JSONObject responseFormat = new JSONObject();
        responseFormat.put("type", "json_object");
        params.put("response_format", responseFormat);
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + API_KEY);
        String response = null;
        try {
            response = HttpUtil.doPostWithHeader(ChatGlm4_URL, params, 30000, headers);
            JSONObject jsonObject = JSON.parseObject(response);
            JSONArray choices = jsonObject.getJSONArray("choices");
            JSONObject choice = choices.getJSONObject(0);
            JSONObject content = choice.getJSONObject("message").getJSONObject("content");
            JSONArray answer = content.getJSONArray("answer");
            list = answer.toJavaList(String.class);
        } catch (Exception e) {
            log.info("大模型-{}，调用异常:{}","glm-4-flash",e.getMessage());
            log.info("返回结果：{}",response);
        }
        return list;
    }

    public static void main(String[] args) {
        List<String> list = wordRecommend("人工智能|汽车");
        System.out.println(JSON.toJSONString(list));
    }
}
