package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SubjectDictMap;
import com.zzsn.event.service.SubjectDictMapService;
import com.zzsn.event.mapper.SubjectDictMapMapper;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.DictVO;
import com.zzsn.event.vo.SubjectBindLabelParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
* @author lenovo
* @description 针对表【subject_dict_map(专题-字典关系表)】的数据库操作Service实现
* @createDate 2025-03-28 11:56:32
*/
@Service
public class SubjectDictMapServiceImpl extends ServiceImpl<SubjectDictMapMapper, SubjectDictMap> implements SubjectDictMapService{

    @Override
    public void modify(SubjectBindLabelParam bindLabelParam) {
        String subjectId = bindLabelParam.getSubjectId();
        List<String> dictIdList = bindLabelParam.getDictIdList();
        LambdaQueryWrapper<SubjectDictMap> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectDictMap::getSubjectId,subjectId);
        int count = this.count(queryWrapper);
        if (count > 0) {
            this.remove(queryWrapper);
        }
        List<SubjectDictMap> subjectDictMaps = new ArrayList<>();
        for (String dictId : dictIdList) {
            SubjectDictMap subjectDictMap = new SubjectDictMap();
            subjectDictMap.setSubjectId(subjectId);
            subjectDictMap.setDictId(dictId);
            subjectDictMaps.add(subjectDictMap);
        }
        this.saveBatch(subjectDictMaps);
    }

    @Override
    public List<DictVO> boundList(String subjectId) {
        //直接绑定的字典
        List<DictVO> dictVOS = baseMapper.boundList(subjectId);
        //流程中标签模型绑定字典
        List<DictVO> dictArrange = baseMapper.boundArrangeList(subjectId);
        dictVOS.addAll(dictArrange);
        if(dictArrange.isEmpty()){
            //未绑定流程的（可能）查询老逻辑保定的字典
            List<DictVO> dictOld = baseMapper.boundOldList(subjectId);
            dictVOS.addAll(dictOld);
        }
        List<String> ids = dictVOS.stream().filter(dictVO -> StringUtils.isEmpty(dictVO.getCode())).map(DictVO::getId).collect(Collectors.toList());
        if(!ids.isEmpty()){
            //添加到开头，优先保留这部分数据
            dictVOS.addAll(0,baseMapper.findLabelType(ids));
        }
        //按照id和code去重
        dictVOS = dictVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getId() + o.getCode()))), ArrayList::new));
        return dictVOS;
    }
}




