package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.SubjectType;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.SubjectTreeVO;

import java.util.List;

/**
 * @Description: 专题类别
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
public interface ISubjectTypeService extends IService<SubjectType> {

    /**
     * 可用的专题分类列表
     *
     * @param userId 用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/29
     */
    List<Node> enableList(String userId,String customerId);

    /**
     * 获取分类下的所有节点id集合
     *
     * @param typeId 分类id
     * @param userId 用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/29
     */
    List<String> belowIdList(String typeId,String userId,String customerId);

    /**
     * 新增专题分类
     *
     * @param subjectType 专题分类
     * @author lkg
     * @date 2024/4/29
     */
    void add(SubjectType subjectType);

    /**
     * 编辑专题分类
     *
     * @param subjectType 专题分类
     * @author lkg
     * @date 2024/4/29
     */
    void edit(SubjectType subjectType);

    /**
     * 删除专题分类
     *
     * @param typeId 专题分类id
     * @author lkg
     * @date 2024/4/29
     */
    void delete(String typeId);

    /**
     * 可用的专题和专题分类列表
     *
     * @param userId 用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/29
     */
    List<SubjectTreeVO> subjectAndTypeTree(String userId, String customerId);

    /**
     * 可用的专题和客户列表
     *
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/30
     */
    List<SubjectTreeVO> subjectAndCustomerTree(String userId,String customerId);

}
