package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: 专题与信息源关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
@Data
@TableName("subject_info_source_map")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="subject_info_source_map对象", description="专题与信息源关联表")
public class SubjectInfoSourceMap implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**专题id*/
	@Excel(name = "专题id", width = 15)
    @ApiModelProperty(value = "专题id")
    private String subjectId;
	/**信息源id或信息源组id*/
	@Excel(name = "信息源id或信息源组id", width = 15)
    @ApiModelProperty(value = "信息源id或信息源组id")
    private String sourceId;
	/**种类（1：信息源id  2：信息源组id）*/
	@Excel(name = "种类（1：信息源id  2：信息源组id）", width = 15)
    @ApiModelProperty(value = "种类（1：信息源id  2：信息源组id）")
    private Integer type;
    @ApiModelProperty(value = "信息源组权重")
    private String weight;
}
