package com.zzsn.event.constant;

import java.util.HashMap;
import java.util.Map;

public class Constants {

    private Constants() { }

    public static final String DATA_ADD_ID = "DATA_ADD_ID:";

    //信息源网址入缓存前缀
    public static final String SITE_NAME_KEY = "SITE_NAME_KEY:";

    //事件专题-redis缓存key前缀
    public static final String SUBJECT_ANALYSIS_PRE = "SUBJECT_ANALYSIS::";
    //传播路径
    public static final String PROPAGATION_KEY = "PROPAGATION_PATH::";

    public static String[] FETCH_FIELDS_STATISTIC = {"id", "subjectId","title","origin", "publishDate", "sourceAddress"};
    public static String[] FETCH_FIELDS_DATA = {"id", "subjectId", "title", "content", "publishDate", "origin", "sourceAddress"};
    //es 专题库索引
    public static final String SUBJECT_INDEX = "subjectdatabase";
    //es 采集库索引
    public static final String COLLECT_INDEX = "basedata";
    public static final String COLLECT_MIDDLE_INDEX = "middlesubjectdatabase";
    //专题事件脉络展示 伪事件脉络 的资讯数量阈值
    public static final int FAKE_NUM = 6;

    //kafka 发送分析命令 主题
    public static final String EVENT_VIEWPOINT_SEND_DATA = "event_viewpoint_send_data";
    //kafka 发送 事件脉络所需信息 主题
    public static final String EVENT_CONTEXT_SEND_TOPIC = "event_context_send_data";
    //kafka 发送 伪事件脉络所需信息 主题
    public static final String FAKE_EVENT_CONTEXT_SEND_TOPIC = "fake_event_context_send_data";
    //kafka 发送 事件挖掘信息 主题
    public static final String EVENT_DIG_SEND_TOPIC = "event_dig_send_data";


    //kafka 接收 观点分析结果 主题
    public static final String VIEWPOINT_RECEIVE_TOPIC = "event_viewpoint_result_data";
    //kafka 接收 事件脉络结果 主题
    public static final String EVENT_CONTEXT_RECEIVE_TOPIC = "event_context_result_data";
    //kafka 接收 伪事件脉络结果 主题
    public static final String FAKE_EVENT_CONTEXT_RECEIVE_TOPIC = "fake_event_context_result_data";
    //kafka 接收 事件分析报告 主题
    public static final String EVENT_REPORT_RECEIVE_TOPIC = "event_report_result_data";
    //kafka 接收 事件挖掘 主题
    public static final String EVENT_DIG_RECEIVE_TOPIC = "event_dig_result_data";

    //重复数索引ku
    public final static String ES_REPEAT_OLD = "repeathold";


    public final static String HEADER_KEY = "X-Access-Token";
    //用户-普通用户
    public static final Integer COMMON_USER = 2;
    //用户-管理员用户
    public static final Integer ADMIN_USER = 3;
    /*数据权限类型*/
    public final static String PERMISSION_SUBJECT = "subject";

    public static final Integer SUCCESS_CODE = 200;

    //事件默认绑定模型集合
    public static final Map<String, String> DEFAULT_MODEL = new HashMap<String, String>() {{
        put("1706918153597943809","3");
        put("1720047300406849537","31");
        put("1723954452169232385","1");
        put("1725396958677307394","3");
    }};

    //事件默认绑定搜索引擎id集合
    public static final Map<String, String> DEFAULT_SEARCH_ENGINE = new HashMap<String, String>() {{
        put("1539145903551361026","3");
        put("1539146006513135617","4");
        put("1539146115049140225","5");
    }};

    /**
     * 关键词数据入缓存 key前缀
     */
    public static final String KEY_WORDS_TO_REDIS_PREFIX = "KEY_WORDS_TO_REDIS::";
    //关键词采集通道
    public static final String KEY_WORDS_COLLECT_TOPIC = "eventKeyWordsInfo";

    /**获取真正的来源*/
    public static String getRealOrigin(String origin){
        String[] splitArr = new String[]{"-","－"};
        String split = null;
        boolean contain = false;
        for (String s : splitArr) {
            if (origin.contains(s)) {
                contain = true;
                split = s;
                break;
            }
        }
        if (contain) {
            int index = origin.indexOf(split);
            origin = origin.substring(0, index);
        }
        return origin;
    }

    public static final String HISTORY_SUBJECT_DATE_QUEUE = "HISTORY_DATE_QUEUE:";
    public static final String HISTORY_EVENT_DATE_QUEUE = "HISTORY_EVENT_DATE_QUEUE:";

    //obs  文件浏览地址 前部分
    public static final String OBS_FILE_PATH_URL_PREFIX = "http://obs.ciglobal.cn/";
    /**专题模型处理中断缓存*/
    public static final String SUBJECT_MODEL_DETAIL_BREAK = "SUBJECT_MODEL_DETAIL_BREAK::";
}
