package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 信息源和标签关系表
 * </p>
 *
 * @author obcy
 * @since 2025-01-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("clb_label_info_source_map")
public class ClbLabelInfoSourceMap extends Model<ClbLabelInfoSourceMap> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建日期
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 更新日期
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 实体唯一编码
     */
    @TableField("entity_code")
    private String entityCode;

    /**
     * 标签值唯一编码
     */
    @TableField("label_item_code")
    private String labelItemCode;

    /**
     * 标签唯一编码
     */
    @TableField("label_code")
    private String labelCode;

    /**
     * 标签附加属性
     */
    @TableField("extra_code")
    private String extraCode;

    /**
     * 业务口径（1自定义，2实体数仓表引用，3字典引用）
     */
    @TableField("business_caliber")
    private Integer businessCaliber;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
