package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.FileDownloadCenter;
import com.zzsn.event.mapper.FileDownloadCenterMapper;
import com.zzsn.event.service.FileDownloadCenterService;
import org.springframework.stereotype.Service;

/**
 * 下载中心
 *
 * @author lkg
 * @date 2024/7/8
 */
@Service
public class FileDownloadCenterServiceImpl extends ServiceImpl<FileDownloadCenterMapper, FileDownloadCenter> implements FileDownloadCenterService {


    @Override
    public String getNoRepeatName(String name,String username) {
        LambdaQueryWrapper<FileDownloadCenter> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.likeRight(FileDownloadCenter::getName,name)
                .eq(FileDownloadCenter::getCommitBy,username)
                .orderByDesc(FileDownloadCenter::getCreateTime)
                .last("limit 1");
        FileDownloadCenter one = this.getOne(queryWrapper);
        if (one != null) {
            String fileName = one.getName();
            if (!fileName.contains("(")) {
                name = fileName + "(1)";
            } else {
                String split = fileName.split("\\(")[1];
                String replace = split.replace(")", "");
                int count = Integer.parseInt(replace) + 1;
                name = fileName.replace(replace,String.valueOf(count));
            }
        }
        return name;
    }
}
