package com.zzsn.event.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.constant.Result;
import com.zzsn.event.constant.TreeNodeInfo;
import com.zzsn.event.entity.GroupMainType;
import com.zzsn.event.entity.InfoSourceMainGroup;
import com.zzsn.event.mapper.GroupMainTypeMapper;
import com.zzsn.event.service.IGroupMainTypeService;
import com.zzsn.event.service.InfoSourceMainGroupService;
import com.zzsn.event.vo.GroupMainTypeVo;
import com.zzsn.event.vo.InfoSourceGroupPage;
import com.zzsn.event.vo.InfoSourceMainGroupPage;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotNull;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description: 信息源组类别
 * @Author: jeecg-boot
 * @Date: 2021-11-25
 * @Version: V1.0
 */
@Service
public class GroupMainTypeServiceImpl extends ServiceImpl<GroupMainTypeMapper, GroupMainType> implements IGroupMainTypeService {

    @Autowired
    private InfoSourceMainGroupService iInfoSourceMainGroupService;

    @Override
    public List<GroupMainTypeVo> listByParentId(String parentId) {
        if (!parentId.equals("0")) {
            GroupMainType parent = this.getById(parentId);
            if (null == parent) {
                throw new RuntimeException("参数parentId不存在");
            }
            if (StringUtils.isEmpty(parent.getHasChild()) || "0".equals(parent.getHasChild())) {
                List<GroupMainTypeVo> finalList = new ArrayList<>();
                //查询当前节点下的所有信息源组
                List<InfoSourceMainGroupPage> pageList = iInfoSourceMainGroupService.listByTypeId(Arrays.asList(parentId),1);
                if (pageList != null && pageList.size() > 0) {
                    for (InfoSourceMainGroupPage infoSourceGroupPage : pageList) {
                        GroupMainTypeVo groupTypeVo2 = new GroupMainTypeVo();
                        groupTypeVo2.setId(infoSourceGroupPage.getId());
                        groupTypeVo2.setHasChild(null);
                        groupTypeVo2.setTypeName(infoSourceGroupPage.getGroupName());
                        groupTypeVo2.setPid(parentId);
                        groupTypeVo2.setIsGroup(true);
                        finalList.add(groupTypeVo2);
                    }
                }
                return finalList;
            }
        }

        GroupMainTypeVo groupTypeVo = new GroupMainTypeVo();
        groupTypeVo.setId("0");
        groupTypeVo.setTypeName("所有");
        groupTypeVo.setPid("0");
        groupTypeVo.setHasChild("1");
        List<GroupMainTypeVo> list = super.list().stream().map(e -> {
            GroupMainTypeVo groupTypeVo1 = new GroupMainTypeVo();
            BeanUtils.copyProperties(e, groupTypeVo1);
            return groupTypeVo1;
        }).collect(Collectors.toList());
        Map<String, List<GroupMainTypeVo>> pidMap = list.stream().collect(Collectors.groupingBy(GroupMainTypeVo::getPid));
//        List<GroupMainType> firstGroup = list.stream().filter(item -> item.getPid().equals(parentId)).collect(Collectors.toList());
        List<GroupMainTypeVo> firstGroup = list.stream().filter(item -> item.getPid().equals(parentId)).map(e -> {
            GroupMainTypeVo groupTypeVo1 = new GroupMainTypeVo();
            BeanUtils.copyProperties(e, groupTypeVo1);
            return groupTypeVo1;
        }).collect(Collectors.toList());

        for (GroupMainTypeVo typeVo : firstGroup) {
            if (StringUtils.isEmpty(typeVo.getHasChild()) || "0".equals(typeVo.getHasChild())) {
                List<String> oneInList = new ArrayList<>();
                oneInList.add(typeVo.getId());
                //tips 当数据量大 最好不用列表

                Integer count = iInfoSourceMainGroupService.countListByTypeAndIdList(oneInList,"1");
                typeVo.setChildrenCount(count);
            } else {
                //获取每个下面最后一级分类列表
                List<GroupMainTypeVo> singleList = new ArrayList<>(1);
                singleList.add(typeVo);
                List<GroupMainTypeVo> finalGradeList = new ArrayList<>();
                getFinalIdListInMap(singleList, pidMap, finalGradeList);
                List<String> finalIdList = finalGradeList.stream().map(GroupMainTypeVo::getId).collect(Collectors.toList());
                if (!finalIdList.isEmpty()) {
                    Integer count = iInfoSourceMainGroupService.countListByTypeAndIdList(finalIdList,"1");
                    typeVo.setChildrenCount(count);
                } else {
                    typeVo.setChildrenCount(0);
                }
            }

        }
        return firstGroup;
    }

    @Override
    public void deleteGroupType(String id) {
        GroupMainType byId = super.getById(id);
        String pid = byId.getPid();
        super.remove(Wrappers.<GroupMainType>lambdaQuery().like(GroupMainType::getPathIds,id));
        /**处理之前父节点的hasChild字段*/
        updateOldParentNode(pid);
    }

    @Override
    public Result<?> addGroupType(GroupMainType groupMainType) {



        List<GroupMainType> list = super.list(Wrappers.<GroupMainType>lambdaQuery()
                .and(e -> e.eq(GroupMainType::getTypeName, groupMainType.getTypeName()))
        );

        if (CollectionUtil.isNotEmpty(list)){
            return Result.FAIL("节点名称已存在");
        }

        if (org.apache.commons.lang3.StringUtils.isBlank(groupMainType.getPid())){
            groupMainType.setPid(TreeNodeInfo.ROOT_PID_VALUE);
        }else {
            GroupMainType parent = super.getById(groupMainType.getPid());
            if(parent != null && !TreeNodeInfo.HAS_CHILD.equals(parent.getHasChild())){
                parent.setHasChild(TreeNodeInfo.HAS_CHILD);
                super.updateById(parent);
            }
        }
        groupMainType.setHasChild(TreeNodeInfo.NO_CHILD);
        groupMainType.setCreateTime(new Date());
        super.save(groupMainType);

        if (TreeNodeInfo.ROOT_PID_VALUE.equals(groupMainType.getPid())){
            groupMainType.setPathIds(groupMainType.getId());
        }else {
            GroupMainType parent = super.getById(groupMainType.getPid());
            groupMainType.setPathIds(parent.getPathIds() +","+ groupMainType.getId());
        }
        super.updateById(groupMainType);
        return Result.OK(groupMainType);
    }

    @Override
    public Result<?> updateGroupType(GroupMainType groupMainType) {


        GroupMainType byId = super.getById(groupMainType.getId());
        if (ObjectUtils.isEmpty(byId)){
            return Result.FAIL("未找到对应的节点");
        }
        String oldPid = byId.getPid();
        String newPid = groupMainType.getPid();
        if(!oldPid.equals(newPid)) {
            /**不允许移动到子节点下*/
            if (TreeNodeInfo.HAS_CHILD.equals(byId.getHasChild())){
                List<GroupMainType> childIds = super.list(Wrappers.<GroupMainType>lambdaQuery().like(GroupMainType::getPathIds, byId.getId()).select(GroupMainType::getId));
                if (CollectionUtil.isNotEmpty(childIds)){
                    List<String> collect = childIds.stream().map(GroupMainType::getId).collect(Collectors.toList());
                    if (collect.contains(newPid)) {
                        return Result.FAIL("不允许移动到子节点下");
                    }
                }

            }
            /**处理之前父节点的hasChild字段*/
            updateOldParentNode(oldPid);

            if(org.apache.commons.lang3.StringUtils.isBlank(newPid) || TreeNodeInfo.ROOT_PID_VALUE.equals(newPid)){
                groupMainType.setPid(TreeNodeInfo.ROOT_PID_VALUE);
                newPid = groupMainType.getPid();
            }
            /**处理新的父节点的hasChild字段*/
            if(!TreeNodeInfo.ROOT_PID_VALUE.equals(newPid)) {
                super.update(Wrappers.<GroupMainType>lambdaUpdate().set(GroupMainType::getHasChild,TreeNodeInfo.HAS_CHILD).eq(GroupMainType::getId,newPid));
            }
            groupMainType.setUpdateTime(new Date());
            super.updateById(groupMainType);

            /**处理本节点的所有子节点的绝对路径*/
            List<GroupMainType> list = super.list(Wrappers.<GroupMainType>lambdaQuery().like(GroupMainType::getPathIds,groupMainType.getId()));
            if (CollectionUtil.isNotEmpty(list)){
                String finalNewPid = newPid;
                if (!TreeNodeInfo.ROOT_PID_VALUE.equals(finalNewPid)) {
                    /**非根节点 移动到其他非根节点*/
                    GroupMainType projectPid = super.getById(finalNewPid);

                    if (!TreeNodeInfo.ROOT_PID_VALUE.equals(oldPid)) {
                        String id = groupMainType.getId();
                        String fullPath = groupMainType.getPathIds();
                        String replace = fullPath.replace(id, "");

                        list.forEach(e->{
                            String path = projectPid.getPathIds()+"," + e.getPathIds().replace(replace, "");
                            e.setPathIds(path);
                        });
                    }else {
                        /**根节点 移动到其他非根节点*/
                        list.forEach(e->{
                            String path = projectPid.getPathIds()+","+e.getPathIds();
                            e.setPathIds(path);
                        });
                    }
                }else {
                    String id = groupMainType.getId();
                    String fullPath = groupMainType.getPathIds();
                    String replace = fullPath.replace(id, "");
                    /**移动到根节点*/
                    list.forEach(e->{
                        String path = e.getPathIds().replace(replace, "");
                        e.setPathIds(path);
                    });
                }
                super.updateBatchById(list);
            }

        }else {
            groupMainType.setUpdateTime(new Date());
            super.updateById(groupMainType);
        }
        return Result.OK(groupMainType);
    }

    @Override
    public void deleteGroupTypeByIds(List<String> list) {

        LambdaQueryWrapper<GroupMainType> queryWrapper = Wrappers.<GroupMainType>lambdaQuery();
        for (String s : list) {
            queryWrapper.or(e -> e.like(GroupMainType::getPathIds,s));
        }
        super.remove(queryWrapper);
    }

    @Override
    public Result<?> getInfoGroupTypeTree() {
        List<GroupMainType> list = super.list();

        List<TreeNode<String>> nodeList = getTreeNodes(list);
        List<Tree<String>> treeList = TreeUtil.build(nodeList, "0");
        return Result.OK(treeList);
    }

    @Override
    public Result<?> sourceGroupPermissionQueryList(String groupName) {
        List<InfoSourceMainGroupPage> list = baseMapper.sourceGroupPermissionQueryList(groupName);
        if (CollectionUtil.isEmpty(list)){
            return Result.OK();
        }else {
            Map<String, List<InfoSourceMainGroupPage>> collect = list.stream().filter(f -> StrUtil.isNotBlank(f.getTypeId())).collect(Collectors.groupingBy(InfoSourceMainGroupPage::getTypeId));
            return Result.OK(collect);
        }

    }

    @Override
    public List<GroupMainTypeVo> allList(Boolean contain, String subjectId, String keywords) {


        List<GroupMainTypeVo> allList = new ArrayList<>();
        GroupMainTypeVo groupTypeVo = new GroupMainTypeVo();
        groupTypeVo.setId("0");
        groupTypeVo.setTypeName("所有");
        groupTypeVo.setPid("0");
        groupTypeVo.setHasChild("1");
        List<GroupMainTypeVo> list = super.list().stream().map(e -> {
            GroupMainTypeVo groupTypeVo1 = new GroupMainTypeVo();
            BeanUtils.copyProperties(e, groupTypeVo1);
            return groupTypeVo1;
        }).collect(Collectors.toList());
        List<String> collect = list.stream().map(GroupMainTypeVo::getId).collect(Collectors.toList());
        //若contain=true 则把与各个类别绑定的信息源组当成类别的子节点,并且只展示状态为启动的

        List<InfoSourceMainGroupPage> infoSourceGroupPageList = iInfoSourceMainGroupService.listByTypeIdList( collect, subjectId, 1, keywords);

        if(null!=keywords){
            if(infoSourceGroupPageList.isEmpty()){
                return Collections.EMPTY_LIST;
            }
            return infoSourceGroupPageList.stream().map(item -> GroupMainTypeVo.builder()
                    .id(item.getId())
                    .typeName(item.getGroupName())
                    .build()).collect(Collectors.toList());
        }
        if (contain) {
            Map<String, List<InfoSourceMainGroupPage>> map = infoSourceGroupPageList.stream().collect(Collectors.groupingBy(InfoSourceMainGroupPage::getTypeId));
            for (int i = 0; i < list.size(); i++) {
                GroupMainTypeVo groupTypeVo1 = list.get(i);
                if (StringUtils.isEmpty(groupTypeVo1.getHasChild())) {
                    List<InfoSourceMainGroupPage> pageList =map.get(groupTypeVo1.getId());
                    if (pageList != null && pageList.size() > 0) {
                        for (InfoSourceMainGroupPage infoSourceGroupPage : pageList) {
                            GroupMainTypeVo groupTypeVo2 = new GroupMainTypeVo();
                            groupTypeVo2.setId(infoSourceGroupPage.getId());
                            groupTypeVo2.setHasChild(null);
                            groupTypeVo2.setTypeName(infoSourceGroupPage.getGroupName());
                            groupTypeVo2.setPid(groupTypeVo1.getId());
                            groupTypeVo2.setIsGroup(true);
                            list.add(groupTypeVo2);
                        }
                    }
                }
            }
        }

        List<GroupMainTypeVo> typeList = getTreeList(list);
        groupTypeVo.setChildren(typeList);
        allList.add(groupTypeVo);
        return allList;
    }
    //获取授权用户业务分类信息，树状结构
    private List<GroupMainTypeVo> getTreeList(List<GroupMainTypeVo> authTypeList) {
        List<GroupMainTypeVo> topList = new ArrayList<>();
        authTypeList.forEach(e -> {
            if ("0".equals(e.getPid())) {
                topList.add(e);
            }
        });
        for (GroupMainTypeVo groupTypeVo : topList) {
            setChildren(groupTypeVo, authTypeList);
        }
        return topList;
    }
    //递归获取树形结构数据
    private void setChildren(GroupMainTypeVo parent, List<GroupMainTypeVo> list) {
        Set<GroupMainTypeVo> children = getChildren(list, parent.getId());
        parent.setChildren(new ArrayList<>(children));
        for (GroupMainTypeVo groupTypeVo : children) {
            setChildren(groupTypeVo, list);
        }
    }
    private Set<GroupMainTypeVo> getChildren(List<GroupMainTypeVo> list, String id) {
        Set<GroupMainTypeVo> children = new HashSet<>();
        for (GroupMainTypeVo infoSourceTypeVo : list) {
            if (infoSourceTypeVo.getPid().equals(id)) {
                children.add(infoSourceTypeVo);
            }
        }
        return children;
    }
    @NotNull
    private List<TreeNode<String>> getTreeNodes(List<GroupMainType> list) {
        List<TreeNode<String>> nodeList = new ArrayList<>();

        list.forEach(e -> {
            TreeNode<String> treeNode = new TreeNode<>();
            treeNode.setExtra(BeanUtil.beanToMap(e,false,true));
            treeNode.setId(e.getId());
            treeNode.setName(e.getTypeName());
            treeNode.setParentId(e.getPid());
            nodeList.add(treeNode);

        });
        return nodeList;
    }

    /**
     * 根据所传pid查询旧的父级节点的子节点并修改相应状态值
     * @param pid
     */
    private void updateOldParentNode(String pid) {
        if(!TreeNodeInfo.ROOT_PID_VALUE.equals(pid)) {
            Integer count = baseMapper.selectCount(Wrappers.<GroupMainType>lambdaQuery().eq(GroupMainType::getPid,pid));
            if(count==null || count<=1) {
                super.update(Wrappers.<GroupMainType>lambdaUpdate().set(GroupMainType::getHasChild,TreeNodeInfo.NO_CHILD).eq(GroupMainType::getId,pid));
            }
        }
    }
    private void getFinalIdListInMap(List<GroupMainTypeVo> groupTypeVoList, Map<String, List<GroupMainTypeVo>> pidMap, List<GroupMainTypeVo> finalGroupTypeVoList) {
        List<GroupMainTypeVo> nextGradeNotFinalList = new ArrayList<>();
        for (GroupMainTypeVo subjectTypeVo : groupTypeVoList) {
            List<GroupMainTypeVo> tempList = pidMap.get(subjectTypeVo.getId());
            if (tempList != null) {
                List<GroupMainTypeVo> finalList = tempList.stream()
                        .filter(item -> null == item.getHasChild() && StringUtils.isEmpty(item.getHasChild()) || "0".equals(item.getHasChild()))
                        .collect(Collectors.toList());
                finalGroupTypeVoList.addAll(finalList);
                tempList.removeAll(finalList);
                nextGradeNotFinalList.addAll(tempList);
            }

        }
        if (nextGradeNotFinalList.isEmpty()) {
            return;
        }
        getFinalIdListInMap(nextGradeNotFinalList, pidMap, finalGroupTypeVoList);
    }
}
