package com.zzsn.event.service;

import com.zzsn.event.entity.Subject;
import com.zzsn.event.vo.InfoDataSearchCondition;
import com.zzsn.event.vo.SearchWordVO;
import com.zzsn.event.vo.SubjectDetailVO;
import com.zzsn.event.vo.SubjectSimpleVO;

import java.util.List;

/**
 * 简化专题创建流程
 *
 * @author lkg
 * @date 2025/1/9
 */
public interface SubjectSimpleService {

    /**
     * 新增专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/14
     */
    Subject createSubject(SubjectSimpleVO subjectSimpleVO);

    /**
     * 编辑专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/14
     */
    void editSubject(SubjectSimpleVO subjectSimpleVO);

    /**
     * 专题绑定关键词信息
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/14
     */
    List<SearchWordVO> subjectBindWordInfo(String subjectId);

    /**
     * 专题详情(包含样例文章以及关键词)
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/14
     */
    SubjectDetailVO queryInfo(String subjectId);

    /**
     * 删除专题
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/14
     */
    void removeSubject(String subjectId);

    /**
     * 批量添加至精选
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/1/14
     */
    void selected(InfoDataSearchCondition searchCondition);

    /**
     * 批量移除精选
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/1/14
     */
    void removeSelected(InfoDataSearchCondition searchCondition);

    /**
     * 批量删除
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/1/14
     */
    void batchRemove(InfoDataSearchCondition searchCondition);
}
