package com.zzsn.event.permit;

import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.feign.api.DataPermitClient;
import com.zzsn.event.feign.api.DataPermitClientProd;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Slf4j
public class ParamAop {
    @Autowired
    private DataPermitClient dataPermitClient;
    @Autowired
    private DataPermitClientProd dataPermitClientProd;



    public UQueryEntity startArs(UQueryEntity queryEntity,String accesstoken,String environment){
        JSONObject params = new JSONObject();
        params.put("userId", queryEntity.getUserId());
        params.put("flagCode", queryEntity.getFlagCode());
        params.put("dbType", EnumDBType.MYSQL);
        params.put("dataType", EnumDataType.NEWS);
        try {
            JSONObject jo = new JSONObject();
            if(StringUtils.isNotBlank(environment) && environment.equals("2")){
                jo = dataPermitClientProd.getQueryEntity(params,accesstoken);
            }else{
                jo = dataPermitClient.getQueryEntity(params,accesstoken);
            }
            if (jo!=null) {
                if (jo.containsKey("condition")) {
                    String jSONString = JSONObject.toJSONString(jo.get("condition"));
                    queryEntity.setSql(SqlConditionUtil.get(JSONObject.parseObject(jSONString)));
                }
                if (jo.containsKey("fields")) {
                    queryEntity.setFields(jo.getString("fields"));
                }
                if (jo.containsKey("shareIds")) {
                    queryEntity.setShardIds(jo.getJSONArray("shareIds").toJavaList(String.class));
                }
            }
        } catch (Exception ex) {
            log.error("{}", ex);
        }
        return queryEntity;
    }
}
