package com.zzsn.event.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Es对日期类型处理
 * @author kongliufeng
 * @create 2020-08-07 14:05
 */
public class EsDateUtil {

    /**
     * yyyy-MM-dd HH:mm:ss ->yyyy-MM-ddTHH:mm:ss
     * @param data
     * @return
     */
    public static String esFieldDateFormat(String data) {
        if (data == null)
            return data;
        if (data.length() == 19) {//标准yyyy-MM-dd HH:mm:ss
            return data.replace(" ", "T");
        } else if (data.length() == 10) {//yyyy-MM-dd
            return data;
        }
        return null;
    }

    /**
     * yyyy-MM-dd HH:mm:ss ->yyyy-MM-ddTHH:mm:ss
     * @param data
     * @return
     */
    public static String esFieldDateMapping(String data) {
        if (data == null)
            return data;
        if (data.length() == 19) {//标准yyyy-MM-dd HH:mm:ss
            return data.replace("T", " ");
        } else if (data.length() == 10) {//yyyy-MM-dd
            return data;
        }
        return null;
    }

    /**
     * yyyy-MM-dd HH:mm:ss ->yyyy-MM-dd
     * @param data
     * @return
     */
    public static String esFieldDateYmd(String data) {
        // 创建一个SimpleDateFormat对象，用于解析和格式化日期
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy年M月d日");
        try {
            if (data == null){
                return data;
            }
            // 解析输入的日期字符串
            Date date = inputFormat.parse(data);
            // 格式化日期为指定的输出格式
            String formattedDate = outputFormat.format(date);
            return formattedDate;
        } catch (ParseException e) {
            // 输入的日期格式不正确时，打印错误信息
            System.out.println("日期格式错误"+e);
        }
        return null;
    }
}
