package com.zzsn.event.controller.yjzx;

import com.zzsn.event.constant.Result;
import com.zzsn.event.service.IEventCategoryService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.tree.TreeUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 事件分类
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
@Slf4j
@Api(tags="事件分类")
@RestController
@RequestMapping("/eventCategory")
public class EventCategoryController {

	@Autowired
	private IEventCategoryService eventCategoryService;
	/**
	 * 获取树状数据
	 *
	 * @return
	 */
	@ApiOperation(value="获取树状数据", notes="获取树状数据")
	@GetMapping(value = "/treeData")
	public Result<?> treeData() {
		List<Node> nodes = eventCategoryService.categoryList();
		List<Node> tree = TreeUtil.tree(nodes, "0");
		return Result.OK(tree);
	}

}
