package com.zzsn.event.util;

import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2023/11/28 16:20
 * @Content: 获取索引名称的工具类
 */
public class EsIndexUtil {

    /**
     * 根据索引名称获取带有当前年的索引名称 subjectdatabase --> subjectdatabase_2023
     * @param index
     * @return
     */
    public static String getIndexYear(String index){
        return index + "_" + LocalDateTime.now().getYear();
    }
    /**
     * 获取最近两年的索引名称 subjectdatabase --> subjectdatabase_2023
     * 并返回数组
     * @param index
     * @return
     */
    public static String[] getIndexLatelyTwoYear(String index){
        String[] indexs;
        Integer year = LocalDateTime.now().getYear();
        if(year <= 2023){//索引年份是从2023年开始的
            indexs = new String[]{index + "_2023"};
        } else {
            String index_1 = index + "_" + year;
            String index_2 = index + "_" + (year-1);
            indexs = new String[]{index_1, index_2};
        }
        return indexs;
    }


    /**
     * 获取两个时间之间的所有年份
     * 并返回数组
     * @param startYear 搜索范围开始年份
     * @param endYear 搜索范围结束年份
     * @return
     */
    public static String[] getIndexIntervalYear(String index, Integer startYear, Integer endYear){
        if(startYear < 2023){
            startYear = 2023; //索引年份是从2023年开始的
        }
        int nowYear = LocalDateTime.now().getYear();
        if(endYear > nowYear) {
            endYear = nowYear;
        }

        String[] indexs;
        if(endYear <= 2023){//索引年份是从2023年开始的
            indexs = new String[]{index + "_2023"};
        } else {
            List<String> result = new ArrayList<>();
            while (startYear <= endYear) {
                result.add(index + "_" + startYear);
                startYear++;
            }
            indexs = result.toArray(new String[0]);
        }
        if(indexs.length == 0) {
            indexs = new String[]{index};
        }
        return indexs;
    }
    /**
     * 获取两个时间之间的所有年份
     * 并返回数组
     * @param startDate 搜索范围开始年份
     * @param endDate 搜索范围结束年份
     * @return
     */
    public static String[] getIndexIntervalYear(String index, String startDate, String endDate){

        Integer startYear;
        Integer endYear;
        if (StringUtils.isNotBlank(startDate)) {
            try {
                String s = startDate.substring(0, 4);
                startYear = Integer.parseInt(s);
            } catch (Exception e1) {
                startYear = LocalDateTime.now().getYear()-1;
            }
        } else {
            startYear = LocalDateTime.now().getYear()-1;
        }
        if (StringUtils.isNotBlank(endDate)) {
            try {
                String s = endDate.substring(0, 4);
                endYear = Integer.parseInt(s);
            } catch (Exception e1) {
                endYear = LocalDateTime.now().getYear();
            }
        } else {
            endYear = LocalDateTime.now().getYear();
        }
        String[] indexs = getIndexIntervalYear(index,startYear,endYear);
        return indexs;
    }

}
