package com.zzsn.event.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.entity.ClbSubjectHitwordsMap;
import com.zzsn.event.mapper.ClbSubjectHitwordsMapMapper;
import com.zzsn.event.service.ClbSubjectHitwordsMapService;
import com.zzsn.event.service.InformationService;
import com.zzsn.event.util.RedisUtil;
import com.zzsn.event.vo.InfoDataSearchCondition;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * <p>
 * 流程编排 服务实现类
 * </p>
 *
 * @author obcy
 * @since 2025-04-23
 */
@Service
@Slf4j
public class ClbSubjectHitwordsMapServiceImpl extends ServiceImpl<ClbSubjectHitwordsMapMapper, ClbSubjectHitwordsMap> implements ClbSubjectHitwordsMapService {

    @Autowired
    private InformationService informationService;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public void delEs(List<ClbSubjectHitwordsMap> clbSubjectHitwordsMaps) {
        if (CollectionUtils.isEmpty(clbSubjectHitwordsMaps)) {
            return;
        }
        String subjectId = clbSubjectHitwordsMaps.get(0).getSubjectId();

        InfoDataSearchCondition searchCondition = new InfoDataSearchCondition();
        searchCondition.setSubjectId(subjectId);
        searchCondition.setStatus(0);
        searchCondition.setKeywordList(new ArrayList<>());
        if (CollectionUtil.isNotEmpty(clbSubjectHitwordsMaps)) {

            for (ClbSubjectHitwordsMap clbSubjectHitwordsMap : clbSubjectHitwordsMaps) {
                if (StrUtil.isNotBlank(clbSubjectHitwordsMap.getWordName())) {
                    searchCondition.getKeywordList().add(clbSubjectHitwordsMap.getWordName());
                }
            }

        }
        if (CollectionUtil.isEmpty(searchCondition.getKeywordList())) {
            log.info("命中词为空，不删除es");
            return;
        }
        log.info("delEs:{}",searchCondition);
        CompletableFuture.runAsync(()-> informationService.removeWordLabel(searchCondition));

    }

    @Override
    public void stopTask(InfoDataSearchCondition searchCondition) {
        String flowId = searchCondition.getFlowId();
        String subjectId = searchCondition.getSubjectId();
        List<String> taskIds = baseMapper.detail(flowId,subjectId);
        if (CollectionUtil.isNotEmpty(taskIds)) {
            taskIds.forEach(taskId -> {
                redisUtil.hset(Constants.SUBJECT_MODEL_DETAIL_BREAK+subjectId,taskId,"1");
            });
        }
    }
}
