package com.zzsn.event.service;

import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.entity.ClbLabelItem;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 公用服务
 *
 * @author lkg
 * @date 2024/12/17
 */
public interface CommonService {

    /**
     * 栏目集合
     *
     * @author lkg
     * @date 2024/9/13
     */
    List<Node> columnList(List<String> columnIds);

    /**
     * 项目集合
     *
     * @author lkg
     * @date 2024/9/13
     */
    List<Node> projectList();

    /**
     * 企业标签下的企业信用代码集合
     *
     * @param labelIds 企业标签id集合
     * @author lkg
     * @date 2024/5/6
     */
    List<String> codesByLabels(List<String> labelIds);

    /**
     * @param subjectId 专题/事件id
     * @param type      模型类别
     * @param category  类别(1-专题;2-事件)
     * @author lkg
     * @date 2024/12/17
     */
    JSONObject siteInfo(String subjectId, String type, Integer category);

    List<KeyWordsPage> selectKeyWordsListById(String subjectId);

    /**
     * 专题/事件绑定 关键词组数量
     *
     * @param idList 专题/事件id集合
     * @author lkg
     * @date 2024/12/18
     */
    List<SubjectPage> bindKeyWordsCountList(List<String> idList);

    /**
     * 专题/事件实际绑定信息源的集合
     *
     * @param subjectIds 专题/事件id集合
     * @author lkg
     * @date 2024/4/24
     */
    List<SubjectSourceVO> bindSourceList(List<String> subjectIds);

    /**
     * 获取所有节点
     */
    List<ModelVO> allList(String subjectType);

    /**
     * 专题下模型绑定的标签信息
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2024/12/20
     */
    List<LabelModelVo> subjectModelBindLabels(List<String> subjectIds);

    /**
     * 根据专题或栏目配置查询关键词黑名单
     */
    Set<String> getExcludeKeywords(String databaseIds);

    /**
     * 下载模板文件
     *
     * @param response 响应
     * @param path     文件路径
     * @author lkg
     * @date 2025/1/4
     */
    void downloadTemplate(HttpServletResponse response, String path);

    /**
     * 信息源绑定的标签信息集合
     *
     * @param sidList 信息源id集合
     * @author lkg
     * @date 2025/2/5
     */
    List<LabelItemMapVO> infoSourceLabelsBySidList(List<String> sidList);

    /**
     * 按专题分组查询绑定信息源数量
     * @param subjectIds 专题id列表
     * @return
     */
    Map<String, Integer> bindSourceCount(List<String> subjectIds);
}
