package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.EventAnalysisVersionRecord;
import com.zzsn.event.enums.AnalysisColumnEnum;
import com.zzsn.event.service.EventAnalysisVersionRecordService;
import com.zzsn.event.mapper.EventAnalysisVersionRecordMapper;
import org.springframework.stereotype.Service;

/**
* @author lenovo
* @description 针对表【event_analysis_version_record(事件分析版本记录表)】的数据库操作Service实现
* @createDate 2025-07-16 16:34:46
*/
@Service
public class EventAnalysisVersionRecordServiceImpl extends ServiceImpl<EventAnalysisVersionRecordMapper, EventAnalysisVersionRecord>
    implements EventAnalysisVersionRecordService{

    @Override
    public String getVersionData(String versionId, Integer columnCode) {
        String result = null;
        LambdaQueryWrapper<EventAnalysisVersionRecord> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventAnalysisVersionRecord::getVersionId, versionId)
                .eq(EventAnalysisVersionRecord::getColumnCode, columnCode);
        EventAnalysisVersionRecord eventAnalysisVersionRecord = this.getOne(queryWrapper);
        if (eventAnalysisVersionRecord != null) {
            result = eventAnalysisVersionRecord.getReturnData();
        }
        return result;
    }

    @Override
    public void modify(String versionId, AnalysisColumnEnum analysisColumnEnum, String data) {
        EventAnalysisVersionRecord versionRecord = EventAnalysisVersionRecord.of(versionId, analysisColumnEnum, data);
        LambdaQueryWrapper<EventAnalysisVersionRecord> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventAnalysisVersionRecord::getVersionId, versionId)
                .eq(EventAnalysisVersionRecord::getColumnCode, analysisColumnEnum.getCode());
        int count = this.count(queryWrapper);
        if (count > 0) {
            this.update(versionRecord, queryWrapper);
        } else {
            this.save(versionRecord);
        }
    }
}




